/*

    (simple) gameengine
  
*/

// gameengine
// add objects
// collision
// draw ...

// engine for the gameobjects

class GameObjectEngine { 
  
    constructor() { 

     // print("GameObjectEngine init");
     
      this.clear();  
   }
  
      clear() {
          
        this.root = new GameObject();
        this.root.visual = "";
        
      }
  
      // automatic used ... 
      // after drawAfter .. 
      service() {
        this.render();
//       this.updateGameObjectComplex();
        this.collisionGameObjects();
      }
  
      render() {
          this.root.renderGameObject( 0, 0 );
      }
  
      collisionGameObjects() {
        // collide all gameobjects
        // collect all gameobjects
        var allGameObjects = this.getAllObjects()
        
        // collide each object with each other object
        for (var c=0;c<allGameObjects.length;c++) {
          
          var oo = allGameObjects[c];
          if (!oo.state) continue;
          if (!oo.collision) continue;
          
          
          for (var d=0;d<allGameObjects.length;d++) {
            if (c!=d) {
              // now collide them!
              
              var ood = allGameObjects[d];

              if (!ood.state) continue;
              if (!ood.collision) continue;
              
              // circle(oo.tmpX,oo.tmpY,5);
              // circle(ood.tmpX,ood.tmpY,5);
              /*
                  
                  oo.x   ood.x
                  oo.y   
              
              */
            
              if ((oo.tmpX+oo.width)>(ood.tmpX)) {
              if ((oo.tmpY+oo.height)>(ood.tmpY)) {
              if ((oo.tmpX)<(ood.tmpX+ood.width)) {
              if ((oo.tmpY)<(ood.tmpY+ood.height)) {
                // render something here ...
                // fill(10)
                // circle(oo.tmpX,oo.tmpY,30);
                
                // executed twice!!!
                objectA = oo;
                objectB = ood;
                onGameObjectCollision();
                oo.onCollision(ood);
              }
              }
              }
              }
            
//              onGameObjectCollision( objectA, objectB )
            }
          }          
        }
        
      }

      updateGameObjectComplex() {
          this.root.updateGameObjectComplex( );
      }
  
      
  
      renderDebug() {
        
        // print("renderDebug");
        
        var strX = "";
        
        strX += this.root.debug(0);
        
        // displays all objects in a list ... 
        text("GameObjects: "+ this.root.arrChildren.length+"\n"+strX,50,50)

        // print("---"+this.root.arrChildren.length);
      
      }
  
      addGameObject( obj ) {
          
        this.root.addGameObject( obj );
        
      }
  
      getAllObjects() {
        
        return this.root.getNodeChildren();
        
      }
  
}

// the function is on ... 

// filled in objectA, objectB ! 
function onGameObjectCollision(  ) {
      
   //  circle(objectA.tmpX,objectA.tmpY,10);
  // objectA.state = false;
  // objectB.state = false;

}

class GameObject {  
  

   // constructor   
   constructor() { 

     this.clear();
    
   }

     clear() {

         this.parent = null; // parent in the structure ... 
       
         this.state = true;
         this.collision = true;
       
         this.layer = ""; 
       
         this.x = 0;
         this.y = 0;
         this.z = 0;
       
         this.width = 10;
         this.height = 10;
         this.depth = 10;
       
         this.visual = "circle"; // point | rect | circle* | shape* | picture *
       
         this.name = "anonymous";
         this.arrChildren = [];
       
         
       
         // for rendering
       
         this.tmpX = 0;
         this.tmpY = 0;
         this.tmpZ = 0;
       
         
       
     } 
  
    getNodeChildren() {
      var arrAll = [];
      
      arrAll[arrAll.length] = this;
      
      var arrChildrenX = this.getChildrenFlat();
      
      for (var v=0;v<arrChildrenX.length;v++) {
        var childY =  arrChildrenX[v];
        var arrT = childY.getNodeChildren();
        for (var t=0;t<arrT.length;t++) {
          arrAll[arrAll.length] = arrT[t];
        }
      }
      
      return arrAll;      
    }
  
        getChildrenFlat() {
          var arrChildren = [];

          // this.arrChildren[this.arrChildren.length]
          for (var i=0;i<this.arrChildren.length;i++) {
            var ac = this.arrChildren[i];
            arrChildren[arrChildren.length] =ac;
          }
          
          return arrChildren;
        }
  
  
    updateGameObject() {
      
      
    }
  
     addGameObject( obj ) {

        obj.parent = this;
        this.arrChildren[this.arrChildren.length] = obj;
    }
  
    onCollision( obj ) {
      
    }
  
  
    debug( depthLev) {
      
      var str = "";
      for (var u=0;u<depthLev;u++) {
        str += " ";
      }
      str += this.state+" [ "+this.layer+" ] ("+this.x+") ";
      
      // add children too ... 
      for (var h=0;h<this.arrChildren.length;h++) {
         var hobj = this.arrChildren[h];
         str += "\n"+hobj.debug(depthLev+1);
      }
      
      return str
    }
  
    renderDebug() {
      
      
    }
  
    renderGameObjectPure( tmpx, tmpy ) {

      
      // not visible ... 
      if (this.visual=="") {
        // circle(this.tmpX-1,this.tmpY-1,1);
      }      
      if (this.visual=="point") {
        circle(this.tmpX-1,this.tmpY-1,1);
      }      
      if (this.visual=="circle") {
        circle(this.tmpX+this.width/2,this.tmpY+this.width/2,-this.width);
      }
      if (this.visual=="rect") {
        rect(this.tmpX,this.tmpY,this.width,this.height);
      }
      
    }
  
    // render gameobject complex
    // layer ? 
    renderGameObject( tmpx, tmpy ) {
        
        if (this.state) {
          
          // ... 
          this.tmpX = tmpx+this.x;
          this.tmpY = tmpy+this.y;      

          fill(0);

          this.renderGameObjectPure(this.tmpX,this.tmpY);
          // circle(this.tmpX,this.tmpX,4);

          // render now the children ...
          for (var h=0;h<this.arrChildren.length;h++) {
             var hobj = this.arrChildren[h];
             hobj.renderGameObject( this.tmpX, this.tmpY );
          }   
        }
    }
  
    updateGameObjectComplex( ) {
        
        if (this.state) {
          
          this.updateGameObject();

          // render now the children ...
          for (var h=0;h<this.arrChildren.length;h++) {
             var hobj = this.arrChildren[h];
             hobj.updateGameObjectComplex();
          }   
        }
    }
  
}

/*

  GameObjectGameEngine

*/
var gameobjectEngine;

 gameobjectEngine = new GameObjectEngine();

/*
 var nop = new GameObject();
  nop.x=100;
  nop.y=150;
 gameobjectEngine.addGameObject( nop );

     var nopx = new GameObject();
      nopx.x = 10;
      nopx.y = 30;
     nop.addGameObject( nopx );

  nopx = new GameObject();
      nopx.x = 40;
      nopx.y = 10;
      nopx.visual = "rect";
     nop.addGameObject( nopx );

  nopxT = new GameObject();
      nopxT.x = 4;
      nopxT.y = 1;
      nopxT.visual = "rect";
     nopx.addGameObject( nopxT );
*/