// --------------------------------------
// CodeComplexVM
// --------------------------------------

// runs a small pieceof
// of javascript
// 

    // --------------------------------------
    // CodeObject
    // --------------------------------------

    // container for codecomplex / line
    class CodeObject { 

      constructor() {
        
        this.parent = null;

        this.sourceCode = "";
        this.sourceCodeLineNumber=0;
        
        this.active = true; 
        this.canBeToggled = true; 
        this.commented = false;    
        this.depth = 0;
        
        this.indirectcommented = false; // if structure and co

        this.error = 0; 
        this.errorString = "";

        // block or not?
        // | block 
        this.blockType = "codeline";
        // function | if | while | for    
        this.blockTypeName = "";    
          this.compiled = false; // is compiled? > direct eval() after 
          this.partOfFunction = ""; // function xyz .. 
        
        this.tmpBlockLineNumber = 0;
              
                // all the CodeObjects you find here 
        this.arrCodeObjects = [];

        // todo! ... 
        this.possibleActions = 0; // x || 0 disabled || -1 endless

        // display ... 
        this.display = ""; //* normal || censored || fog
        // - smeary - inout - effect ... censored /*v:c*/ etc /*v:i*/ 
   
        this.displayCounter = 0; 
        
        // arg (temp)
        this.arg = 0;
        
        // position - tmp
        this.tmpX = 0;
        this.tmpY = 0;
        
        // size 
        this.tmpCodeSize = 0;

        this.tmpCommentedByBlock = 0; // in a commented block!
      }

      // ----------------------------
      // GET SOURCECODE
      // ----------------------------
      /*
    
        getSourceCodeRecursive()
    
      */
      getSourceCodeRecursive(  ) {
         return this.getSourceCodeRecursiveExt( this );
      }

        getSourceCodeRecursiveExt( objSourceCode ) {
            var linex = "";
            linex += objSourceCode.getSourceLine();
            // go through all lines          
            for (var g=0;g<objSourceCode.arrCodeObjects.length;g++) {
              var gox = objSourceCode.arrCodeObjects[g];
              var addonx = "";
              if (gox.commented) { addonx = "// "}
              linex += "\n"+addonx+objSourceCode.getSourceCodeRecursiveExt( gox );
            }          
            return linex;
        }

        getSourceLine() {
          return this.getSourceLineExt(false);
        }

      getSourceLineExt( extF ) {
         return this.getSourceLineExtreme( extF, true );
      }
      
        getSourceLineExtreme( extF, diffCommentsFlag ) {
          var linex = "";
              
            // simple line
            if (this.blockType=="codeline") linex = this.sourceCode;
            
            // complex line
            if (this.blockType=="complex") {
              linex = this.blockTypeName+" ";
              linex += this.sourceCode+" {";
            }
          
            
          
            if (extF) {
               if (this.commented) {
                  linex = "//"+linex;
               }
               if (diffCommentsFlag) {
                   if (!this.canBeToggled) {
                      linex = "/**/"+linex;
                   }
                   if (this.display=="black") {
                      linex = "/*b*/"+linex;
                   }
                   if (this.display=="fog") {
                      linex = "/*f*/"+linex;
                   }
                   if (this.display=="standon") {
                      linex = "/*s*/"+linex;
                   }

                   // instant/compiled
                   if (this.compiled) {
                      linex = "/*c*/"+linex;
                   }
               }
               
              
               // todo: /*c*/
               // execute ... here ..       
              
            }
          
            if (diffCommentsFlag) {
                if (this.display!="") {
                      linex = "";
                }                
            }
          
          return linex;
        }
      
      
      // ----------------------------
      // ADD ACTIONCODE
      // ----------------------------

      // ------------
      // addCode
      // ------------
      
      addCodeObjectLine( sourceCodeLine ) {

        sourceCodeLine = sourceCodeLine.trim();

        var commentFlag = false;
        var canbetoggled = true;

        // todo: change to indexOf 
        // /*c*/ etc ... 
        
        // "/**/"
        if (sourceCodeLine.indexOf("/**/")==0) {
          // console.log("notoggle "+sourceCodeLine);
          sourceCodeLine = sourceCodeLine.substring(4);
          canbetoggled = false;
        }

        // "//"
        if (sourceCodeLine.indexOf("//")==0) {
          sourceCodeLine = sourceCodeLine.trim();
          sourceCodeLine = sourceCodeLine.substring(2);
          // console.log("commented "+sourceCodeLine);
          commentFlag = true;
        }

        // if | while | for  

        return this.addCodeObjectExt( sourceCodeLine, commentFlag, canbetoggled  );

      }  

      addCodeObject( sourceCode ) {
         return addCodeObjectExt( sourceCode, true, false  );
      }  

	  // complex
      addCodeObjectComplexExt( ctype, sourceCode, commented, canbetoggled ) {

        var objxComplex=new CodeObject();

            objxComplex.blockType="complex";
            objxComplex.blockTypeName=ctype;

            objxComplex.sourceCode=sourceCode;
            objxComplex.commented=commented;
            objxComplex.canBeToggled=canbetoggled;

            objxComplex.partOfFunction = actualAddFunction;
        
        this.arrCodeObjects.push(objxComplex);

		
        // add vr? 
        
        return objxComplex;

      }

      addCodeObjectExt( sourceCode, commented, canbetoggled ) {

        var objx=new CodeObject();

            objx.sourceCode=sourceCode;
            objx.commented=commented;
            objx.canBeToggled=canbetoggled;
            objx.partOfFunction = actualAddFunction;
                
        this.arrCodeObjects.push(objx);


        return objx;
      }


    }

// ------------------------------
// CodeComplexVirtualMaschine
// ------------------------------

class CodeComplexVM { 


  constructor() {
    
  
    // execution
    this.executor = -1; // line - start ... 
    this.executorSpeed = 20; // count up ... 
    this.executorCounter = 0; // count up ... 
        this.executorLastStep = -1; // line - start ... 
    
    // false
    this.executorPause = false;
    
//    this.actualMethode = this.codeObjRoot // which methode?
    
    // coder
    this.coder = 0; // line

    this.codeObjRoot = new CodeObject();  
      this.codeObjRoot.blockType="complex";
      this.codeObjRoot.blockTypeName="SourceCode";    
 
    
    this.clearCodeObjects();
    
    this.clearTempFlatLinePages();

   
    
  }
  
  clearTempFlatLinePages() {

    this.codeObjRoot = new CodeObject();  
      this.codeObjRoot.blockType="complex";
      this.codeObjRoot.blockTypeName="SourceCode";   
    
     // flatted code objects
    this.tmpArrCodeObjectsFlated = [];

    // tmp
    this.tmpSourceCodeLineCounter = 0; 

    // the pages ... 
    this.arrEditorPages = [];
    this.actualEditorPage = 0;
    
  }


  /*
      Coders Action
  */  

  coderToggleComment() {

    if (this.coder<(this.tmpArrCodeObjectsFlated.length-1)) {
      
      var obC = this.tmpArrCodeObjectsFlated[this.coder];
      if (obC!=null) {
        if (obC.canBeToggled) {
         
          var doToggle = true;
        
          if (isCursorAction(obC.sourceCode)) {
             doToggle = false;           
          }
          
          if (doToggle) {
            
              obC.commented = ! obC.commented;

    //          console.log("actualAddFunction "+obC.partOfFunction);          
             this.compileCompiledfunction( obC.partOfFunction );

              return obC;
            }
            
        }
        if (!obC.canBeToggled) {
          if (!isCursorAction(obC.sourceCode)) {
            cprint("// editor: no toogling");
          }
        }
        
      } else {
        console.log("coderToggleComment() not found object");
        
      }
      
      
    } else {
      console.log("coderToggleComment() not found object");
    }
    
    return null;
    
  }
  
     // --------------------------------
     // execute a compiled function
     // --------------------------------
     compileCompiledfunction( partOfFunction ) {
        
         var func = ccVM.getSourceObjectTypeAndContent( 
                             "function", partOfFunction );
         // compiled object
          if (func!=null) {
            if (func.compiled) {

              // compile now !!!
              // alert("compile! "+partOfFunction);

              var evalstr = func.getSourceCodeRecursive();
              // alert("evalstr! "+evalstr);
              // console.log("evalstr "+evalstr);

              try {
                window.eval(evalstr);                          
              } catch( e ) {
                showError( evalstr, e )
              }

            }
          } else {
            // console.log("Could not compile: "+);
          }
  }

  
/*
      getTypeAndContent
  */  

  // getSourceObjectAt( 101 )
  getSourceObjectAt( ind ) {

    if ((ind>=0)&&(ind<this.tmpArrCodeObjectsFlated.length)) {
      return this.tmpArrCodeObjectsFlated[ind];    
    }
    return null;
    
  }  

  
  /*
      getTypeAndContent
  */  

  // getTypeAndContent( "function", "update()" )
  getSourceObjectTypeAndContent( typex, namex ) {

    for (var u=0;u<this.tmpArrCodeObjectsFlated.length;u++) {
      var obC = this.tmpArrCodeObjectsFlated[u];
      // blockType = 'complex'
      if (obC.blockTypeName==typex) {
        if (obC.sourceCode==namex) {
          return obC;
        }         
        
      } 
    
    }    
    return null;
    
  }
  
  // ---------------------
  // clear action codes
  // ---------------------
  clearCodeObjects() {
  // complex object as root !
    this.codeObjRoot = new CodeObject();  
      this.codeObjRoot.blockType="complex";
      this.codeObjRoot.blockTypeName="SourceCode";    
    
    // focus    
    this.focusCodeObj = this.codeObjRoot;  
    this.focusPath = [];
    this.focusPath.push(this.focusCodeObj);      
  }
  
  // -----------------
  // add Action Code 
  // -----------------
    addCodeObjectComplexExtVM( ctype, sourceCode, commented, canbetoggled ) {
        
        var objU = this.focusCodeObj.addCodeObjectComplexExt( ctype, sourceCode, commented, canbetoggled );
        
        this.focusUp(objU);
        
        objU.depth = this.focusPath.length;

        
        // console.log("upComplex "+this.focusCodeObj.depth);
        
        return objU;
      }


      addCodeObjectLineVM( sourceCodeLine ) {

          var objU = this.focusCodeObj.addCodeObjectLine( sourceCodeLine );
          sourceCodeLine = sourceCodeLine.trim();

        
          this.focusUp(objU);
          objU.depth = this.focusPath.length;
          this.focusDown();

        
          if (sourceCodeLine=="}") {
            // up again ... 
            // console.log("sourceCodeLine="+sourceCodeLine);
            this.focusDown();
          } 

          return objU;
        }  

/*
  addCodeObject( sourceCode ) {

        var objU =  this.focusCodeObj.addCodeObjectExt( sourceCode, true, false  );
        // objU.parent = this.focusCodeObj;

        return objU;
      }   
  */
  

  
    focusUp(objU) {

        // store parents (it is a tree .-) )
        objU.parent = this.focusCodeObj;
          
        this.focusCodeObj = objU;        
        this.focusPath.push( this.focusCodeObj );

       // console.log("focusUp "+this.focusPath.length+"  "+objU.sourceCode);

      }
  
      focusDown() {
        this.focusPath.pop( );
        this.focusCodeObj = this.focusPath[this.focusPath.length-1];
       //  console.log("downComplex "+this.focusPath.length+" "+this.focusCodeObj.sourceCode)
      }
 
    
  

    /*
      addCodeObjectExt( sourceCode, commented, canbetoggled ) {

        objU = this.focusCodeObj.addCodeObjectExt( sourceCode, commented, canbetoggled  );
        
        
        // objU.parent = this.focusCodeObj;

        return objU;
      }
      */
  
  // ----------------------
  // generate flated array 
  // ----------------------  
  generateFlatedCodeObjects() {

    // console.log("generateFlatedCodeObjects()");
    this.tmpArrCodeObjectsFlated = [];
    this.tmpSourceCodeLineCounter= 0;
    this.generateFlatedCodeObjectsStep( this.codeObjRoot );

    // create now the pages
    // and now 
    this.arrEditorPages = [];
    this.actualEditorPage = 0;
    // var
    var startIndex = 0;
    var pages = 0;
    for (var i=0;i<this.tmpArrCodeObjectsFlated.length;i++) {
      var ho = this.tmpArrCodeObjectsFlated[i ];
      // console.log("ho: "+ho.sourceCode);
      if ((ho.commented)&&(ho.sourceCode.indexOf("nextpage")!=-1)) {        
        var ooT = new EditorPage( startIndex, i );
        this.arrEditorPages.push( ooT );        
        startIndex = i+1; 
        pages++;        
        // alert("pages  "+pages);
      }    
    }
    
    // end?
    if (pages==0) {
      // create only one
      var ooT = new EditorPage( 0, this.tmpArrCodeObjectsFlated.length-1 );
      this.arrEditorPages.push( ooT );
      this.actualEditorPage = 0;
    } else {
      // create only one
      var ooT = new EditorPage( startIndex, this.tmpArrCodeObjectsFlated.length-1 );
      this.arrEditorPages.push( ooT );
      this.actualEditorPage = 0;      
    }

  }
  
    generateFlatedCodeObjectsStep( objNode ) {
                
        this.tmpSourceCodeLineCounter++;
        objNode.sourceCodeLineNumber = this.tmpSourceCodeLineCounter;

    
       // SourceObject
       // take its children 
       if (objNode.arrCodeObjects.length>0) {
         
         for (var zardox=0;zardox<objNode.arrCodeObjects.length;zardox++) {

           var hatedchild = objNode.arrCodeObjects[zardox];          
           if (hatedchild.active) {
             
             
             // objNode.sourceCodeLineNumber = this.tmpSourceCodeLineCounter;
             
             // go through all the nodes here
             // example of meaningful+ var
             if (hatedchild.arrCodeObjects.length==0) {
                this.tmpSourceCodeLineCounter++;
                hatedchild.sourceCodeLineNumber = this.tmpSourceCodeLineCounter;

                this.tmpArrCodeObjectsFlated.push(hatedchild);

             }
             if (hatedchild.arrCodeObjects.length>0) {
                             
            	
                this.tmpArrCodeObjectsFlated.push(hatedchild);
                
                this.generateFlatedCodeObjectsStep( hatedchild );
                 
             }
           
           }
           
           
         }
         
       }

    }
  
  // -----------------
  // EditorPage
  // -----------------
  getEditorPage( ind ) {
    if ((ind>=0)&&(ind<this.arrEditorPages.length)) {
      return  this.arrEditorPages[ind];
    }    
    return null;
  }
  
  // --------------------
  // PlayerCodeSize
  // --------------------
  getPlayerCodeSize() {
      var sizecode =0;
      for (var h=0;h<this.tmpArrCodeObjectsFlated.length;h++) {
          var linea = this.tmpArrCodeObjectsFlated[h].getSourceLineExtreme( true, false );
          if (!this.tmpArrCodeObjectsFlated[h].commented) sizecode += linea.length;
          // print(linea);
      }
      return sizecode;
  }

  // -----------------
  //  debugs
  // -----------------
  debugTree() {
    
    var str = "DEBUG-TREE";
    
    // go through the system ...
    
  
    console.log(str );
    
  }
  
  
}

// -----------------
// EditorPage
// -----------------
// > EditorPages ... 

class EditorPage {
  
  constructor( start,end ) {
  
    this.start = start;
    this.end = end;
    // this.index = index;
      
    this.visible = true;    
  }
  
}
