/*==============================================================================

	main.h

	joyosc: a device event to osc bridge

	Copyright (C) 2007, 2010, 2024 Dan Wilcox <danomatika@gmail.com>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program. If not, see <http://www.gnu.org/licenses/>.

==============================================================================*/

#include "App.h"

int main(int argc, char **argv) {
	App app;

	// init config settings
	if(!app.parseCommandLine(argc, argv)) {
		return EXIT_FAILURE;
	}

	// init SDL
	if(SDL_Init(SDL_INIT_JOYSTICK | SDL_INIT_GAMECONTROLLER | SDL_INIT_HAPTIC) < 0) {
		LOG_ERROR << "could not initialize SDL: " << SDL_GetError() << std::endl;
		return EXIT_FAILURE;
	}
	if(SDL_SetHint(SDL_HINT_JOYSTICK_ALLOW_BACKGROUND_EVENTS, "1") == SDL_FALSE) {
		LOG_WARN << "could not set joystick background events" << std::endl;
	}

	// open optional window?
	SDL_Window *window = nullptr;
	if(app.openWindow) {
		window = SDL_CreateWindow(PACKAGE, 50, 100,
			app.windowSize.width, app.windowSize.height, SDL_WINDOW_RESIZABLE);
		if(window == nullptr) {
			LOG_ERROR << "could not create window: " << SDL_GetError() << std::endl;
			SDL_Quit();
			return EXIT_FAILURE;
		}
		app.updateWindow(window);
	}

	// run the application
	app.run();

	// cleanup SDL
	if(window) {
		SDL_DestroyWindow(window);
		window = nullptr;
	}
	SDL_Quit();

	return EXIT_SUCCESS;
}
